<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, X-Auth-Token");
header("Access-Control-Allow-Methods: POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . "/../../../../private/config/conexion.php";

/* ===============================
   1️⃣ TOKEN RH
================================ */
$token = $_SERVER['HTTP_X_AUTH_TOKEN'] ?? '';

if (!$token) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'msg' => 'Token requerido']);
    exit;
}

/* ===============================
   2️⃣ VALIDAR TOKEN
================================ */
$sqlToken = "
    SELECT id
    FROM espaciorh_usuarios
    WHERE token = ?
      AND token_expira > NOW()
    LIMIT 1
";

$stmt = $conn->prepare($sqlToken);
$stmt->bind_param("s", $token);
$stmt->execute();

if ($stmt->get_result()->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['ok' => false, 'msg' => 'Token inválido']);
    exit;
}

/* ===============================
   3️⃣ BODY JSON
================================ */
$input = json_decode(file_get_contents("php://input"), true);

$control_id = $input['control_id'] ?? null;
$estatus    = $input['estatus'] ?? null;
$comentario = $input['comentario'] ?? null;

if (!$control_id || !$estatus) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'msg' => 'control_id y estatus son requeridos']);
    exit;
}

/* ===============================
   4️⃣ VALIDAR ESTATUS
================================ */
$estatusPermitidos = ['APROBADO', 'RECHAZADO'];

if (!in_array($estatus, $estatusPermitidos)) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'msg' => 'Estatus no válido']);
    exit;
}

/* ===============================
   5️⃣ UPDATE
================================ */
$sql = "
    UPDATE espaciorh_documentos_control
    SET
        estatus = ?,
        comentario = ?,
        actualizado_en = NOW()
    WHERE id = ?
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ssi", $estatus, $comentario, $control_id);

if (!$stmt->execute()) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'msg' => 'Error al actualizar estatus']);
    exit;
}

/* ===============================
   6️⃣ RESPUESTA
================================ */
echo json_encode([
    'ok' => true,
    'msg' => 'Estatus actualizado correctamente'
]);
exit;
