<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, X-Auth-Token");
header("Access-Control-Allow-Methods: GET, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . "/../../../../private/config/conexion.php";

/* ===============================
   1️⃣ TOKEN RH
================================ */
$token = $_SERVER['HTTP_X_AUTH_TOKEN'] ?? '';

if (!$token) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'msg' => 'Token requerido']);
    exit;
}

/* ===============================
   2️⃣ VALIDAR TOKEN
================================ */
$sqlToken = "
SELECT id
FROM espaciorh_usuarios
WHERE token = ?
  AND token_expira > NOW()
LIMIT 1
";

$stmt = $conn->prepare($sqlToken);
$stmt->bind_param("s", $token);
$stmt->execute();

if ($stmt->get_result()->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['ok' => false, 'msg' => 'Token inválido']);
    exit;
}

/* ===============================
   3️⃣ PARAMETROS
================================ */
$colaborador_id = $_GET['colaborador_id'] ?? null;

if (!$colaborador_id) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'msg' => 'colaborador_id requerido']);
    exit;
}

/* ===============================
   4️⃣ CONSULTA DOCUMENTOS (BD)
================================ */
$sql = "
SELECT
    dc.id AS control_id,
    dcol.id AS documento_colaborador_id,
    td.id AS tipo_documento_id,
    td.nombre AS tipo_documento,
    pd.nombre AS paquete,
    dc.estatus,
    dc.actualizado_en
FROM espaciorh_documentos_control dc
JOIN espaciorh_documentos_colaborador dcol
    ON dcol.id = dc.documento_colaborador_id
JOIN espaciorh_tipos_documento td
    ON td.id = dc.tipo_documento_id
JOIN espaciorh_paquetes_documento pd
    ON pd.id = dc.paquete_documento_id
WHERE dc.colaborador_id = ?
ORDER BY dc.creado_en ASC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $colaborador_id);
$stmt->execute();
$res = $stmt->get_result();

$documentos = [];
while ($row = $res->fetch_assoc()) {
    $documentos[] = $row;
}

/* ===============================
   5️⃣ RESPUESTA
================================ */
echo json_encode([
    'ok' => true,
    'documentos' => $documentos
]);
exit;
