<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, X-Auth-Token");
header("Access-Control-Allow-Methods: GET, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . "/../../../../private/config/conexion.php";

/* ===============================
   1️⃣ TOKEN RH
================================ */
$token = $_SERVER['HTTP_X_AUTH_TOKEN'] ?? '';

if (!$token) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'msg' => 'Token requerido']);
    exit;
}

/* ===============================
   2️⃣ VALIDAR TOKEN
================================ */
$sqlToken = "
    SELECT id
    FROM espaciorh_usuarios
    WHERE token = ?
      AND token_expira > NOW()
    LIMIT 1
";

$stmt = $conn->prepare($sqlToken);
$stmt->bind_param("s", $token);
$stmt->execute();

if ($stmt->get_result()->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['ok' => false, 'msg' => 'Token inválido']);
    exit;
}

/* ===============================
   3️⃣ PARAMETRO
================================ */
$colaborador_id = $_GET['colaborador_id'] ?? null;

if (!$colaborador_id) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'msg' => 'colaborador_id requerido']);
    exit;
}

/* ===============================
   4️⃣ CONSULTA DOCUMENTOS
================================ */
$sql = "
SELECT
    dc.id               AS control_id,
    dc.documento_colaborador_id,
    dc.tipo_documento_id,
    td.nombre           AS documento,
    dc.estatus,
    dc.comentario,
    dc.actualizado_en
FROM espaciorh_documentos_control dc
JOIN espaciorh_tipos_documentos td
    ON td.id = dc.tipo_documento_id
WHERE dc.colaborador_id = ?
ORDER BY td.nombre
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $colaborador_id);
$stmt->execute();
$res = $stmt->get_result();

$documentos = [];

while ($row = $res->fetch_assoc()) {
    $documentos[] = $row;
}

/* ===============================
   5️⃣ RESPUESTA
================================ */
echo json_encode([
    'ok' => true,
    'data' => $documentos
]);
exit;
