<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit;
}

require_once __DIR__ . "/../../../../private/config/conexion.php";

$data = json_decode(file_get_contents("php://input"), true);

if (
    empty($data['colaborador_id']) ||
    empty($data['paquete_documento_id'])
) {
    echo json_encode([
        "ok" => false,
        "msg" => "Datos incompletos"
    ]);
    exit;
}

$colaboradorId = (int)$data['colaborador_id'];
$paqueteId     = (int)$data['paquete_documento_id'];

try {
    $conn->begin_transaction();

    // ================= VALIDAR COLABORADOR =================
    $stmt = $conn->prepare("
        SELECT id 
        FROM espaciorh_colaboradores 
        WHERE id = ?
        LIMIT 1
    ");
    $stmt->bind_param("i", $colaboradorId);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 0) {
        throw new Exception("Colaborador no válido");
    }

    // ================= VALIDAR PAQUETE =================
    $stmt = $conn->prepare("
        SELECT id 
        FROM espaciorh_paquetes_documentos
        WHERE id = ? AND activo = 1
        LIMIT 1
    ");
    $stmt->bind_param("i", $paqueteId);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 0) {
        throw new Exception("Paquete no válido o inactivo");
    }

    // ================= OBTENER DOCUMENTOS DEL PAQUETE =================
    $stmt = $conn->prepare("
        SELECT tipo_documento_id
        FROM espaciorh_paquetes_documentos_detalle
        WHERE paquete_documentos_id = ?
    ");
    $stmt->bind_param("i", $paqueteId);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        throw new Exception("El paquete no tiene documentos asignados");
    }

    $insertados = 0;

    // ================= INSERTAR DOCUMENTOS =================
    while ($row = $result->fetch_assoc()) {

        $tipoDocumentoId = (int)$row['tipo_documento_id'];

        // Evitar duplicados
        $check = $conn->prepare("
            SELECT id
            FROM espaciorh_documentos_colaborador
            WHERE colaborador_id = ?
              AND tipo_documento_id = ?
              AND paquete_documento_id = ?
            LIMIT 1
        ");
        $check->bind_param("iii", $colaboradorId, $tipoDocumentoId, $paqueteId);
        $check->execute();
        $check->store_result();

        if ($check->num_rows === 0) {

            $insert = $conn->prepare("
                INSERT INTO espaciorh_documentos_colaborador
                (
                    colaborador_id,
                    tipo_documento_id,
                    estatus,
                    paquete_documento_id
                )
                VALUES (?, ?, 'PENDIENTE', ?)
            ");
            $insert->bind_param(
                "iii",
                $colaboradorId,
                $tipoDocumentoId,
                $paqueteId
            );
            $insert->execute();

            $insertados++;
        }
    }

    $conn->commit();

    echo json_encode([
        "ok" => true,
        "msg" => "Paquete asignado correctamente",
        "documentos_insertados" => $insertados
    ]);

} catch (Exception $e) {

    $conn->rollback();

    echo json_encode([
        "ok" => false,
        "msg" => $e->getMessage()
    ]);
}
