<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

require_once __DIR__ . "/../../../../private/config/conexion.php";

try {
   $sql = "SELECT 
            c.id,
            c.numero_colaborador,
            c.nombre,
            c.apellido,
            d.nombre AS departamento,   -- nombre del departamento
            p.nombre AS puesto,         -- nombre del puesto
            c.estatus,
            c.fecha_ingreso,
            c.fecha_baja,
            c.creado_en
        FROM espaciorh_colaboradores c
        LEFT JOIN espaciorh_departamentos d ON c.departamento_id = d.id
        LEFT JOIN espaciorh_puestos p ON c.puesto_id = p.id
        ORDER BY c.nombre ASC";


    $stmt = $conn->prepare($sql);
    $stmt->execute();
    
    $result = $stmt->get_result(); // <- esto convierte a un objeto de resultado
    $colaboradores = $result->fetch_all(MYSQLI_ASSOC); // <- aquí sí obtenemos todos los registros

    echo json_encode([
        "ok" => true,
        "data" => $colaboradores
    ]);

} catch (Exception $e) {
    echo json_encode([
        "ok" => false,
        "msg" => $e->getMessage()
    ]);
}
?>
