<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

require_once __DIR__ . "/../../../../private/config/conexion.php";
try {

    $sql = "SELECT id, nombre, descripcion
            FROM espaciorh_paquetes_documentos
            WHERE activo = 1
            ORDER BY nombre ASC";

    $stmt = $conn->prepare($sql);
    $stmt->execute();

    $result = $stmt->get_result();
    $paquetes = $result->fetch_all(MYSQLI_ASSOC);

    echo json_encode([
        "ok" => true,
        "data" => $paquetes
    ]);

} catch (Exception $e) {

    echo json_encode([
        "ok" => false,
        "msg" => $e->getMessage()
    ]);
}
