<?php
header('Content-Type: application/json');


require_once __DIR__ . "/../../../../private/config/conexion.php";

$usuario_id = $_POST['usuario_id'] ?? '';
$nueva_password = $_POST['nueva_password'] ?? '';

if (!$usuario_id || !$nueva_password) {
    echo json_encode([
        "ok" => false,
        "msg" => "Datos incompletos"
    ]);
    exit;
}

/* ===============================
   Generar hash de contraseña
================================ */
$password_hash = password_hash($nueva_password, PASSWORD_DEFAULT);

/* ===============================
   Generar token de sesión
================================ */
$token = bin2hex(random_bytes(32));
$expira = date('Y-m-d H:i:s', strtotime('+8 hours'));

/* ===============================
   Actualizar usuario
================================ */
$sql = "UPDATE espaciorh_usuarios SET
            password = ?,
            must_change_password = 0,
            token = ?,
            token_expira = ?
        WHERE id = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("sssi", $password_hash, $token, $expira, $usuario_id);

if (!$stmt->execute()) {
    echo json_encode([
        "ok" => false,
        "msg" => "Error al actualizar contraseña"
    ]);
    exit;
}

/* ===============================
   Respuesta final
================================ */
echo json_encode([
    "ok" => true,
    "msg" => "Contraseña actualizada correctamente",
    "token" => $token,
    "token_expira" => $expira
]);
