<?php
header('Content-Type: application/json');

header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

require_once __DIR__ . "/../../../../private/config/conexion.php";

// 11566 Obtener colaborador_id
$colaborador_id = isset($_GET['colaborador_id']) ? intval($_GET['colaborador_id']) : 0;

if ($colaborador_id <= 0) {
    echo json_encode([
        "ok" => false,
        "msg" => "Colaborador no proporcionado"
    ]);
    exit;
}

// 21566 Primero obtenemos el paquete asignado al colaborador
$sql_paquete = "SELECT DISTINCT paquete_documento_id 
                FROM espaciorh_documentos_colaborador 
                WHERE colaborador_id = ? 
                LIMIT 1";
$stmt1 = $conn->prepare($sql_paquete);
$stmt1->bind_param("i", $colaborador_id);
$stmt1->execute();
$res1 = $stmt1->get_result();
if ($res1->num_rows == 0) {
    echo json_encode([
        "ok" => false,
        "msg" => "No se encontr paquete asignado para este colaborador"
    ]);
    exit;
}
$paquete = $res1->fetch_assoc();
$paquete_id = $paquete['paquete_documento_id'];

// 31566 Obtener todos los documentos de ese paquete con LEFT JOIN para el estado
$sql = "SELECT 
            td.id AS tipo_documento_id,
            td.codigo AS tipo_codigo,
            td.nombre AS tipo_nombre,
            td.obligatorio AS tipo_obligatorio,
            COALESCE(dc.estatus, 'PENDIENTE') AS estatus,
            COALESCE(dc.comentario, '') AS comentario,
            COALESCE(dc.actualizado_en, NULL) AS actualizado_en,
            pd.id AS paquete_id,
            pd.nombre AS paquete_nombre,
            pd.descripcion AS paquete_descripcion
        FROM espaciorh_paquetes_documentos pd
        JOIN espaciorh_paquetes_documentos_detalle pdd
            ON pd.id = pdd.paquete_documentos_id
        JOIN espaciorh_tipos_documentos td
            ON pdd.tipo_documento_id = td.id
        LEFT JOIN espaciorh_documentos_control dc
            ON td.id = dc.tipo_documento_id
            AND dc.colaborador_id = ?
            AND dc.paquete_documento_id = pd.id
        WHERE pd.id = ?
        ORDER BY td.id ASC";


$stmt2 = $conn->prepare($sql);
$stmt2->bind_param("ii", $colaborador_id, $paquete_id);
$stmt2->execute();
$result = $stmt2->get_result();

$documentos = [];
while ($row = $result->fetch_assoc()) {
    $documentos[] = $row;
}

echo json_encode([
    "ok" => true,
    "paquete_id" => $paquete_id,
    "data" => $documentos
]);
