<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, X-Auth-Token");
header("Access-Control-Allow-Methods: GET, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . "/../../../../private/config/conexion.php";

/* ===============================
   Obtener token (HOSTING SAFE)
================================ */
$token = '';

if (isset($_SERVER['HTTP_X_AUTH_TOKEN'])) {
    $token = trim($_SERVER['HTTP_X_AUTH_TOKEN']);
}

if (!$token) {
    echo json_encode(["ok" => false, "msg" => "Token requerido"]);
    exit;
}

/* ===============================
   Validar token
================================ */
$sql = "
    SELECT id
    FROM espaciorh_usuarios
    WHERE token = ?
      AND token_expira > NOW()
    LIMIT 1
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $token);
$stmt->execute();
$res = $stmt->get_result();

if ($res->num_rows === 0) {
    echo json_encode(["ok" => false, "msg" => "Token inválido o expirado"]);
    exit;
}

$usuario = $res->fetch_assoc();
$usuarioId = $usuario['id'];

/* ===============================
   Obtener colaborador
================================ */
$sqlCol = "
    SELECT id, numero_colaborador, nombre, apellido,
           departamento_id, puesto_id, estatus, fecha_ingreso
    FROM espaciorh_colaboradores
    WHERE usuario_id = ?
    LIMIT 1
";

$stmtCol = $conn->prepare($sqlCol);
$stmtCol->bind_param("i", $usuarioId);
$stmtCol->execute();
$resCol = $stmtCol->get_result();

if ($resCol->num_rows === 0) {
    echo json_encode(["ok" => false, "msg" => "Colaborador no encontrado"]);
    exit;
}

$colaborador = $resCol->fetch_assoc();

echo json_encode([
    "ok" => true,
    "colaborador" => $colaborador
]);
