<?php
header('Content-Type: application/json');

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: http://127.0.0.1:5500");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

require_once __DIR__ . "/../../../../private/config/conexion.php";

// ===============================
// Recibir datos del formulario
// ===============================
// ===============================
// Recibir datos del formulario
// ===============================
$usuario_id     = $_POST['usuario_id'] ?? null; // obligatorio
$no_colaborador = $_POST['no_colaborador'] ?? null; // ahora opcional
$nombre         = $_POST['nombre'] ?? '';
$apellido       = $_POST['apellido'] ?? '';
$departamento   = $_POST['departamento'] ?? null; // opcional
$puesto         = $_POST['puesto'] ?? null;       // opcional
$estatus        = $_POST['estatus'] ?? '';
$fecha_ingreso  = $_POST['fecha_ingreso'] ?? '';

if (!$usuario_id || !$nombre || !$apellido || !$estatus || !$fecha_ingreso) {
    echo json_encode(["ok" => false, "msg" => "Faltan datos obligatorios"]);
    exit;
}

// ===============================
// Insertar colaborador en espaciorh_colaboradores
// ===============================
$stmt = $conn->prepare("INSERT INTO espaciorh_colaboradores 
    (usuario_id, numero_colaborador, nombre, apellido, departamento_id, puesto_id, estatus, fecha_ingreso, creado_en)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())");

// convertir cadena vacía a NULL para el número de colaborador
$no_colaborador_db = $no_colaborador !== '' ? $no_colaborador : null;

$stmt->bind_param("isssiiss",
    $usuario_id,
    $no_colaborador_db,
    $nombre,
    $apellido,
    $departamento,
    $puesto,
    $estatus,
    $fecha_ingreso
);

try {
    $stmt->execute();
    echo json_encode([
        "ok" => true,
        "msg" => "Colaborador registrado correctamente",
        "colaborador_id" => $stmt->insert_id
    ]);
} catch (mysqli_sql_exception $e) {
    echo json_encode(["ok" => false, "msg" => "Error al crear colaborador: " . $e->getMessage()]);
    exit;
}
