<?php
// Manejar CORS y preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type");
    exit(0);
}

header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

require_once __DIR__ . "/../../../../private/config/conexion.php";

// PHPMailer
require __DIR__. '/../../../PHPMailer/src/Exception.php';
require __DIR__. '/../../../PHPMailer/src/PHPMailer.php';
require __DIR__. '/../../../PHPMailer/src/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// ----------------------
// Recibir datos
// ----------------------
$correo   = $_POST['correo'] ?? '';
$usuario  = $_POST['usuario'] ?? '';
$password = $_POST['password'] ?? '';
$rol_id   = $_POST['rol'] ?? '';

if (!$correo || !$usuario || !$password || !$rol_id) {
    echo json_encode(["ok" => false, "msg" => "Faltan datos obligatorios"]);
    exit;
}

// ----------------------
// Validar correo
// ----------------------
$stmt = $conn->prepare("SELECT id FROM espaciorh_usuarios WHERE correo = ?");
$stmt->bind_param("s", $correo);
$stmt->execute();
$stmt->store_result();
if ($stmt->num_rows > 0) {
    echo json_encode(["ok" => false, "msg" => "El correo ya está registrado"]);
    exit;
}
$stmt->close();

// ----------------------
// Validar usuario
// ----------------------
$stmt = $conn->prepare("SELECT id FROM espaciorh_usuarios WHERE usuario = ?");
$stmt->bind_param("s", $usuario);
$stmt->execute();
$stmt->store_result();
if ($stmt->num_rows > 0) {
    echo json_encode(["ok" => false, "msg" => "El usuario ya existe, intenta otra combinación"]);
    exit;
}
$stmt->close();

// ----------------------
// Insertar usuario
// ----------------------
$passwordHash = password_hash($password, PASSWORD_DEFAULT);
$stmt = $conn->prepare("INSERT INTO espaciorh_usuarios (usuario, correo, password, activo, creado_en, must_change_password) VALUES (?, ?, ?, 1, NOW(), 0)");
$stmt->bind_param("sss", $usuario, $correo, $passwordHash);

try {
    $stmt->execute();
    $usuario_id = $stmt->insert_id;

    // ----------------------
    // Insertar rol en tabla pivote
    // ----------------------
    $stmtRol = $conn->prepare("INSERT INTO espaciorh_usuarios_roles (usuario_id, rol_id) VALUES (?, ?)");
    $stmtRol->bind_param("ii", $usuario_id, $rol_id);
    $stmtRol->execute();
    $stmtRol->close();

    // ----------------------
    // ENVIAR CORREO CON CREDENCIALES
    // ----------------------
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'valvuleriamexicana.org';       // Cambia esto
        $mail->SMTPAuth = true;
        $mail->Username = 'noreply@valvuleriamexicana.org'; // Cambia esto
        $mail->Password = 'Valvul3ri@_25';             // Cambia esto
        $mail->SMTPSecure = 'tls';
        $mail->Port = 587;

        $mail->setFrom('noreply@valvuleriamexicana.org', 'MiEspacioRH');
        $mail->addAddress($correo, $usuario);

        $mail->isHTML(true);
        $mail->Subject = 'Tus credenciales de acceso';
        $mail->Body    = "
            <p>Bienvenido a Valmex</p>
            <p>Se ha creado tu cuenta en MiEspacioRH.</p>
            <p><b>Correo:</b> correo</p>
            <p><b>Contraseña:</b> $password</p>
            <p>Por favor, ingresa con tu correo y contraseña.</p>
        ";

        $mail->send();
        $correoMsg = "Correo enviado correctamente";
    } catch (Exception $e) {
        $correoMsg = "No se pudo enviar el correo: {$mail->ErrorInfo}";
    }

    echo json_encode([
        "ok" => true,
        "msg" => "Usuario creado correctamente. $correoMsg",
        "usuario_id" => $usuario_id
    ]);

} catch (mysqli_sql_exception $e) {
    echo json_encode(["ok" => false, "msg" => "Error al crear usuario: " . $e->getMessage()]);
}

$stmt->close();
$conn->close();
