<?php
require_once __DIR__ . "/../../../../private/config/conexion.php";

/* ===============================
   TOKEN
================================ */
$token = $_SERVER['HTTP_X_AUTH_TOKEN'] ?? '';

if (!$token) {
    http_response_code(401);
    exit("Token requerido");
}

/* ===============================
   VALIDAR TOKEN RH
================================ */
$sqlAuth = "
SELECT id
FROM espaciorh_usuarios
WHERE token = ?
  AND token_expira > NOW()
LIMIT 1
";

$stmtAuth = $conn->prepare($sqlAuth);
$stmtAuth->bind_param("s", $token);
$stmtAuth->execute();

if ($stmtAuth->get_result()->num_rows === 0) {
    http_response_code(403);
    exit("No autorizado");
}

/* ===============================
   DOCUMENTO
================================ */
$id = intval($_GET['id'] ?? 0);
if ($id <= 0) {
    http_response_code(400);
    exit("ID inválido");
}

$sql = "
SELECT
  dc.colaborador_id,
  dc.nombre_archivo
FROM espaciorh_documentos_colaborador dc
WHERE dc.id = ?
LIMIT 1
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();

$res = $stmt->get_result();
$doc = $res->fetch_assoc();

if (!$doc) {
    http_response_code(404);
    exit("Documento no encontrado");
}

/* ===============================
   RUTA PRIVADA REAL
================================ */
$ruta = __DIR__
    . "/../../../../private/espaciorh_storage/"
    . $doc['colaborador_id']
    . "/"
    . $doc['nombre_archivo'];

if (!file_exists($ruta)) {
    http_response_code(404);
    exit("Archivo no existe");
}

/* ===============================
   ENVIAR ARCHIVO
================================ */
$mime = mime_content_type($ruta);

header("Content-Type: $mime");
header("Content-Disposition: inline; filename=\"documento.pdf\"");
header("Content-Length: " . filesize($ruta));

readfile($ruta);
exit;
