<?php
header('Content-Type: application/json');


header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: http://127.0.0.1:5500");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

require_once __DIR__ . "/../../../../private/config/conexion.php";
$correo   = $_POST['correo'] ?? '';
$password = $_POST['password'] ?? '';

if (!$correo || !$password) {
    echo json_encode(["ok" => false, "msg" => "Datos incompletos"]);
    exit;
}

/* ===============================
   Buscar usuario
================================ */
$sql = "SELECT id, usuario, correo, password, activo,
               must_change_password, intentos_fallidos, bloqueado_hasta
        FROM espaciorh_usuarios
        WHERE correo = ?
        LIMIT 1";

$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $correo);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(["ok" => false, "msg" => "Credenciales incorrectas"]);
    exit;
}

$user = $result->fetch_assoc();

/* ===============================
   ¿Usuario bloqueado?
================================ */
if ($user['bloqueado_hasta'] && strtotime($user['bloqueado_hasta']) > time()) {
    echo json_encode([
        "ok" => false,
        "msg" => "Usuario bloqueado temporalmente"
    ]);
    exit;
}

/* ===============================
   Validar activo
================================ */
if ($user['activo'] != 1) {
    echo json_encode(["ok" => false, "msg" => "Usuario inactivo"]);
    exit;
}

/* ===============================
   Validar contraseña
================================ */
$isCorrect      = false;
$passwordPlano  = false;

if (str_starts_with($user['password'], '$2y$')) {
    if (password_verify($password, $user['password'])) {
        $isCorrect = true;
    }
} else {
    if ($password === $user['password']) {
        $isCorrect     = true;
        $passwordPlano = true;
    }
}

if (!$isCorrect) {
    // Incrementar intentos
    $intentos = (int)$user['intentos_fallidos'] + 1;

    $bloqueo = null;
    if ($intentos >= 5) {
        $bloqueo = date('Y-m-d H:i:s', strtotime('+15 minutes'));
        $intentos = 0;
    }

    $up = $conn->prepare(
        "UPDATE espaciorh_usuarios
         SET intentos_fallidos = ?, bloqueado_hasta = ?
         WHERE id = ?"
    );
    $up->bind_param("isi", $intentos, $bloqueo, $user['id']);
    $up->execute();

    echo json_encode(["ok" => false, "msg" => "Credenciales incorrectas"]);
    exit;
}

/* ===============================
   Si password estaba plano → hashear
================================ */
if ($passwordPlano) {
    $hash = password_hash($password, PASSWORD_BCRYPT);

    $up = $conn->prepare(
        "UPDATE espaciorh_usuarios
         SET password = ?, must_change_password = 1
         WHERE id = ?"
    );
    $up->bind_param("si", $hash, $user['id']);
    $up->execute();
}

/* ===============================
   Generar token 1 día
================================ */
$token  = bin2hex(random_bytes(32));
$expira = date('Y-m-d H:i:s', strtotime('+1 day'));

$saveToken = $conn->prepare(
    "UPDATE espaciorh_usuarios
     SET token = ?, token_expira = ?,
         intentos_fallidos = 0, bloqueado_hasta = NULL
     WHERE id = ?"
);
$saveToken->bind_param("ssi", $token, $expira, $user['id']);
$saveToken->execute();


/* ===============================
   Obtener rol del usuario
================================ */
$sqlRol = "
    SELECT r.id, r.nombre
    FROM espaciorh_usuarios_roles ur
    INNER JOIN espaciorh_roles r ON r.id = ur.rol_id
    WHERE ur.usuario_id = ?
    LIMIT 1
";

$stmtRol = $conn->prepare($sqlRol);
$stmtRol->bind_param("i", $user['id']);
$stmtRol->execute();
$resRol = $stmtRol->get_result();

$rol = null;
if ($resRol->num_rows > 0) {
    $rol = $resRol->fetch_assoc();
}




/* ===============================
   Respuesta final
================================ */
echo json_encode([
    "ok" => true,
    "msg" => "Login correcto",
    "token" => $token,
    "token_expira" => $expira,
    "must_change_password" => (bool)$user['must_change_password'],
    "usuario" => [
        "id" => $user['id'],
        "usuario" => $user['usuario'],
        "correo" => $user['correo']
    ],
    "rol" => $rol ? [
        "id" => $rol['id'],
        "nombre" => $rol['nombre']
    ] : null
]);
