<?php
header('Content-Type: application/json');

header('Content-Type: application/json');


header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: http://127.0.0.1:5500");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

require_once __DIR__ . "/../../../../private/config/conexion.php";

$departamentoId = $_GET['departamento_id'] ?? null;

if (!$departamentoId) {
    echo json_encode([
        "ok" => false,
        "msg" => "Departamento no especificado"
    ]);
    exit;
}

try {

    $sql = "
        SELECT id, nombre
        FROM espaciorh_puestos
        WHERE departamento_id = ?
          AND activo = 1
        ORDER BY nombre ASC
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $departamentoId);
    $stmt->execute();
    $result = $stmt->get_result();

    $data = [];
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }

    echo json_encode([
        "ok" => true,
        "data" => $data
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "ok" => false,
        "msg" => "Error al obtener puestos"
    ]);
}
