<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, X-Auth-Token");
header("Access-Control-Allow-Methods: POST, OPTIONS");

// Conexión a la base de datos
require_once __DIR__ . "/../../../../private/config/conexion.php";

/* ===============================
   1️⃣ TOKEN Y COLABORADOR
================================ */
$token = $_SERVER['HTTP_X_AUTH_TOKEN'] ?? '';
$colaborador_id = $_POST['colaborador_id'] ?? null;

if (!$token || !$colaborador_id) {
    echo json_encode(['ok' => false, 'msg' => 'Token o colaborador no especificado']);
    exit;
}

/* ===============================
   2️⃣ VALIDAR TOKEN
================================ */
$sql = "
SELECT u.id AS usuario_id, c.id AS colaborador_id
FROM espaciorh_usuarios u
JOIN espaciorh_colaboradores c ON c.usuario_id = u.id
WHERE u.token = ?
  AND u.token_expira > NOW()
  AND c.id = ?
LIMIT 1
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("si", $token, $colaborador_id);
$stmt->execute();
$res = $stmt->get_result();

if ($res->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['ok' => false, 'msg' => 'Token inválido o no autorizado']);
    exit;
}

/* ===============================
   3️⃣ VALIDAR ARCHIVO
================================ */
if (!isset($_FILES['archivo'])) {
    echo json_encode(['ok' => false, 'msg' => 'No se recibió ningún archivo']);
    exit;
}

$archivo = $_FILES['archivo'];

if ($archivo['type'] !== 'application/pdf') {
    echo json_encode(['ok' => false, 'msg' => 'Solo se permiten archivos PDF']);
    exit;
}

if ($archivo['size'] > (5 * 1024 * 1024)) {
    echo json_encode(['ok' => false, 'msg' => 'Archivo demasiado grande (máx 5 MB)']);
    exit;
}

/* ===============================
   4️⃣ GUARDAR ARCHIVO EN VPS
================================ */
$baseStorage = __DIR__ . '/../../../../private/espaciorh_storage/';
$carpetaColaborador = $baseStorage . $colaborador_id . '/';

if (!is_dir($carpetaColaborador)) {
    mkdir($carpetaColaborador, 0755, true);
}

$nombreSeguro = uniqid('doc_', true) . '.pdf';

$rutaFinal = $carpetaColaborador . $nombreSeguro;

if (!move_uploaded_file($archivo['tmp_name'], $rutaFinal)) {
    echo json_encode(['ok' => false, 'msg' => 'Error al guardar el archivo']);
    exit;
}

/* ===============================
   5️⃣ DATOS DE DOCUMENTO
================================ */
$tipo_documento_id    = $_POST['tipo_documento_id'] ?? null;
$paquete_documento_id = $_POST['paquete_documento_id'] ?? null;

if (!$tipo_documento_id || !$paquete_documento_id) {
    echo json_encode(['ok' => false, 'msg' => 'Datos de documento incompletos']);
    exit;
}

/* ===============================
   6️⃣ DOCUMENTOS ASIGNADOS
   (espaciorh_documentos_colaborador)
================================ */

$sqlDoc = "
INSERT INTO espaciorh_documentos_colaborador
(
    colaborador_id,
    tipo_documento_id,
    paquete_documento_id,
    nombre_archivo,
    estatus,
    actualizado_en
)
VALUES (?, ?, ?, ?, 'PENDIENTE', NOW())
ON DUPLICATE KEY UPDATE
nombre_archivo = VALUES(nombre_archivo),
estatus = 'PENDIENTE',
actualizado_en = NOW()
";

$stmtDoc = $conn->prepare($sqlDoc);
$stmtDoc->bind_param(
    "iiis",
    $colaborador_id,
    $tipo_documento_id,
    $paquete_documento_id,
    $nombreSeguro
);
$stmtDoc->execute();

$documento_colaborador_id = $stmtDoc->insert_id;


/* ===============================
   7️⃣ CONTROL DE ESTATUS RH
   (espaciorh_documentos_control)
================================ */
$sqlControl = "
INSERT INTO espaciorh_documentos_control
(
    colaborador_id,
    tipo_documento_id,
    paquete_documento_id,
    documento_colaborador_id,
    estatus,
    creado_en,
    actualizado_en
)
VALUES (?, ?, ?, ?, 'PENDIENTE', NOW(), NOW())
ON DUPLICATE KEY UPDATE
estatus = 'PENDIENTE',
actualizado_en = NOW()
";

$stmtControl = $conn->prepare($sqlControl);
$stmtControl->bind_param(
    "iiii",
    $colaborador_id,
    $tipo_documento_id,
    $paquete_documento_id,
    $documento_colaborador_id
);
$stmtControl->execute();

/* ===============================
   8️⃣ RESPUESTA FINAL
================================ */
echo json_encode([
    'ok' => true,
    'msg' => 'Documento subido y enviado a control de estatus',
    'estatus' => 'PENDIENTE'
]);
exit;
