<?php
/**
 * Valida token de sesión
 * - Requiere header Authorization: Bearer TOKEN
 * - Verifica expiración
 * - Devuelve datos del usuario
 */
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

require_once __DIR__ . "/../../../../private/config/conexion.php";

function validarToken()
{
    $headers = getallheaders();

    if (!isset($headers['Authorization'])) {
        http_response_code(401);
        echo json_encode([
            "ok" => false,
            "msg" => "Token requerido"
        ]);
        exit;
    }

    $token = trim(str_replace("Bearer", "", $headers['Authorization']));

    if (!$token) {
        http_response_code(401);
        echo json_encode([
            "ok" => false,
            "msg" => "Token vacío"
        ]);
        exit;
    }

    $sql = "SELECT id, usuario, correo, rol, token_expira
            FROM espaciorh_usuarios
            WHERE token = ?
            LIMIT 1";

    $stmt = $GLOBALS['conn']->prepare($sql);
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $res = $stmt->get_result();

    if ($res->num_rows === 0) {
        http_response_code(401);
        echo json_encode([
            "ok" => false,
            "msg" => "Token inválido"
        ]);
        exit;
    }

    $user = $res->fetch_assoc();

    if (strtotime($user['token_expira']) < time()) {
        http_response_code(401);
        echo json_encode([
            "ok" => false,
            "msg" => "Token expirado"
        ]);
        exit;
    }

    return $user;
}
