<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, X-Auth-Token");
header("Access-Control-Allow-Methods: POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . "/../../../../private/config/conexion.php";

/* ===============================
   TOKEN RH
================================ */
$token = $_SERVER['HTTP_X_AUTH_TOKEN'] ?? '';

if (!$token) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'msg' => 'Token requerido']);
    exit;
}

$sqlToken = "
    SELECT id
    FROM espaciorh_usuarios
    WHERE token = ?
      AND token_expira > NOW()
    LIMIT 1
";

$stmtToken = $conn->prepare($sqlToken);
$stmtToken->bind_param("s", $token);
$stmtToken->execute();

if ($stmtToken->get_result()->num_rows === 0) {
    http_response_code(403);
    echo json_encode(['ok' => false, 'msg' => 'Token inválido']);
    exit;
}

/* ===============================
   BODY JSON
================================ */
$input = json_decode(file_get_contents("php://input"), true);

$documento_id = $input['documento_colaborador_id'] ?? null;
$estatus = strtoupper(trim($input['estatus'] ?? ''));
$comentario = $input['comentario'] ?? null;

if (!$documento_id || !$estatus) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'msg' => 'Datos incompletos']);
    exit;
}

/* ===============================
   VALIDAR ESTATUS
================================ */
$estatusPermitidos = ['APROBADO', 'RECHAZADO'];

if (!in_array($estatus, $estatusPermitidos)) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'msg' => 'Estatus no válido']);
    exit;
}

/* ===============================
   VALIDAR EXISTENCIA
================================ */
$sqlExiste = "
    SELECT id
    FROM espaciorh_documentos_colaborador
    WHERE id = ?
    LIMIT 1
";

$stmtExiste = $conn->prepare($sqlExiste);
$stmtExiste->bind_param("i", $documento_id);
$stmtExiste->execute();

if ($stmtExiste->get_result()->num_rows === 0) {
    http_response_code(404);
    echo json_encode(['ok' => false, 'msg' => 'Documento no encontrado']);
    exit;
}

/* ===============================
   ACTUALIZAR ESTATUS
================================ */
$sqlUpdate = "
    UPDATE espaciorh_documentos_colaborador
    SET estatus = ?, actualizado_en = NOW()
    WHERE id = ?
";

$stmtUpdate = $conn->prepare($sqlUpdate);
$stmtUpdate->bind_param("si", $estatus, $documento_id);
$stmtUpdate->execute();

/* ===============================
   (OPCIONAL) GUARDAR COMENTARIO
================================ */
if ($estatus === 'RECHAZADO' && $comentario) {

    $sqlComentario = "
        UPDATE espaciorh_documentos_control
        SET comentario = ?, actualizado_en = NOW()
        WHERE documento_colaborador_id = ?
    ";

    $stmtCom = $conn->prepare($sqlComentario);
    $stmtCom->bind_param("si", $comentario, $documento_id);
    $stmtCom->execute();
}

echo json_encode([
    'ok' => true,
    'msg' => 'Documento validado correctamente',
    'documento_colaborador_id' => $documento_id,
    'estatus' => $estatus
]);
exit;
