<?php
header("Access-Control-Allow-Origin: *");

require_once __DIR__ . "/../../../../private/config/conexion.php";

/* ===============================
   PARAMETROS
================================ */
$documento_id = $_GET['documento_id'] ?? null;
$token        = $_GET['token'] ?? null;

if (!$documento_id || !$token) {
    http_response_code(401);
    exit("Acceso no autorizado");
}

/* ===============================
   VALIDAR TOKEN RH
================================ */
$sqlToken = "
SELECT id
FROM espaciorh_usuarios
WHERE token = ?
  AND token_expira > NOW()
LIMIT 1
";

$stmt = $conn->prepare($sqlToken);
$stmt->bind_param("s", $token);
$stmt->execute();

if ($stmt->get_result()->num_rows === 0) {
    http_response_code(403);
    exit("Token invlido");
}

/* ===============================
   OBTENER DOCUMENTO
================================ */
$sql = "
SELECT colaborador_id, nombre_archivo
FROM espaciorh_documentos_colaborador
WHERE id = ?
LIMIT 1
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $documento_id);
$stmt->execute();
$res = $stmt->get_result();

if ($res->num_rows === 0) {
    http_response_code(404);
    exit("Documento no encontrado");
}

$doc = $res->fetch_assoc();

/* ===============================
   RUTA PRIVADA
================================ */
$ruta = __DIR__ . "/../../../../private/espaciorh_storage/{$doc['colaborador_id']}/{$doc['nombre_archivo']}";

if (!file_exists($ruta)) {
    http_response_code(404);
    exit("Archivo no existe");
}

/* ===============================
   SERVIR PDF
================================ */
header("Content-Type: application/pdf");
header("Content-Disposition: inline; filename=\"{$doc['nombre_archivo']}\"");
header("Content-Length: " . filesize($ruta));

readfile($ruta);
exit;
